
uniform int channel;
uniform sampler3D volumeTexture;
uniform sampler3D volumeTexture2;
uniform sampler2D RGBlookupTexture;
uniform sampler2D RAGABAlookupTexture;
varying vec3 V;
varying vec3 V1;

/*vec3 hsvtorgb(vec3 hsv)
{
    int i; 
    float f, p, q, t,hTemp; 
	vec3 rgb;
	
    if( hsv.y == 0.0 || hsv.x == -1.0) // s==0? Totally unsaturated = grey so R,G and B all equal value 
    { 
      rgb.x = rgb.y = rgb.z = hsv.z; 
      return rgb; 
    }
	
    hTemp = hsv.x/60.0f; 
    i = (int)floor( hTemp );                 // which sector 
    f = hTemp - i;                      // how far through sector 
    p = hsv.z * ( 1 - hsv.y ); 
    q = hsv.z * ( 1 - hsv.y * f ); 
    t = hsv.z * ( 1 - hsv.y * ( 1 - f ) ); 
  
    switch( i )  
    { 
		case 0:{rgb.x = hsv.z;	rgb.y = t;		rgb.z = p;break;} 
		case 1:{rgb.x = q;		rgb.y = hsv.z;	rgb.z = p;break;} 
		case 2:{rgb.x = p;		rgb.y = hsv.z;	rgb.z = t;break;} 
		case 3:{rgb.x = p;		rgb.y = q;		rgb.z = hsv.z;break;}  
		case 4:{rgb.x = t;		rgb.y = p;		rgb.z = hsv.z;break;} 
		case 5:{rgb.x = hsv.z;	rgb.y = p;		rgb.z = q;break;} 
    }
	
	return rgb;
}*/

void main()
{		
	//get the texture rgb data
	float texValue = texture3D(volumeTexture, gl_TexCoord[0].stp).x;
	//if(texValue==0.0) discard;

	//get lookup table values
	//r,g,b,ra,ga,ba
	vec3 RGBlookupValue, RAGABAlookupValue;
	RGBlookupValue = RAGABAlookupValue = vec3(0.0);
	vec4 finalColour = vec4(0.0);

	if(channel==0)
	{
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).x;

		if(RAGABAlookupValue.x == 0.0) discard;

		finalColour = vec4(RGBlookupValue.x, 0.0, 0.0, RAGABAlookupValue.x);

		/*float val = finalColour.x;
		float amplify = 2.0;

		vec3 hsv = vec3(val*80.0, 1.0, 1.0);
		vec3 rgb = hsvtorgb(hsv);

		finalColour.r = rgb.r*(val*amplify);
		finalColour.g = rgb.g*(val*amplify);
		finalColour.b = rgb.b*(val*amplify);*/
	}
	else if(channel==1)
	{
		RGBlookupValue.y = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).y;
		RAGABAlookupValue.y = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).y;
		
		if(RAGABAlookupValue.y == 0.0) discard;

		finalColour = vec4(0.0,RGBlookupValue.y,0.0, RAGABAlookupValue.y);

		/*float val = finalColour.y;
		float amplify = 1.0;
		
		vec3 hsv = vec3((val*360.0), 1.0, 1.0);
		vec3 rgb = hsvtorgb(hsv);
		
		val = 1.0;

		finalColour.r = rgb.r*(val*amplify);
		finalColour.g = rgb.g*(val*amplify);
		finalColour.b = rgb.b*(val*amplify);*/
	}
	else if(channel==2)
	{
		RGBlookupValue.z = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).z;
		RAGABAlookupValue.z = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).z;

		if(RAGABAlookupValue.z == 0.0) discard;

		finalColour = vec4(0.0, 0.0, RGBlookupValue.z, RAGABAlookupValue.z);
		
		/*float val = finalColour.z;
		float amplify = 2.0;

		vec3 hsv = vec3(200+val*80.0, 1.0, 1.0);
		vec3 rgb = hsvtorgb(hsv);

		finalColour.r = rgb.r*(val*amplify);
		finalColour.g = rgb.g*(val*amplify);
		finalColour.b = rgb.b*(val*amplify);*/
	}
	else if(channel==3)
	{		
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue, 0.5)).x;

		if(RAGABAlookupValue.x == 0.0) discard;

		finalColour = vec4(RGBlookupValue.x,RGBlookupValue.x,RGBlookupValue.x, RAGABAlookupValue.x);
		/*float val = finalColour.x;
		float amplify = 2.0;

		vec3 hsv = vec3(val*80.0, 1.0, 1.0);
		vec3 rgb = hsvtorgb(hsv);

		finalColour.r = rgb.r*(val*amplify);
		finalColour.g = rgb.g*(val*amplify);
		finalColour.b = rgb.b*(val*amplify);*/
	}
	else if(channel==4)
	{
		float texValue2 = texture3D(volumeTexture2, gl_TexCoord[0].stp).x;
		
		RGBlookupValue.x = texture2D(RGBlookupTexture, vec2(texValue, 0.5)).x;
		RAGABAlookupValue.x = texture2D(RAGABAlookupTexture, vec2(texValue2, 0.5)).x;

		if(RAGABAlookupValue.x == 0.0) discard;

		finalColour = vec4(RGBlookupValue.x,RGBlookupValue.x,RGBlookupValue.x, RAGABAlookupValue.x);	
	}
/*
	float val = finalColour.x;
	float amplify = 2.0;
	
	vec3 hsv = vec3(val*80.0, 1.0, 1.0);
	vec3 rgb = hsvtorgb(hsv);
	
	finalColour.r = rgb.r*(val*amplify);
	finalColour.g = rgb.g*(val*amplify);
	finalColour.b = rgb.b*(val*amplify);
*/
	
	//assing the colour to our final colour
	gl_FragColor = finalColour;	
}